/* time_private.h
   This header defines the private types, variables and methods for time.
   change history
   06/13/2025 initial version
   06/15/2025 added MYARC_DATE_PATH and time_tm_myarc
   06/17/2025 added get_day_of_week and get_day_of_year
*/

#ifndef TIME_PRIVATE_H
#define TIME_PRIVATE_H

// global time struct
extern struct tm stm;

// paths to the hardware clocks available from the IDE controller and TIPI
#define MYARC_DATE_PATH "TIME"            // note the TI formatted path
#define IDE_DATE_PATH "IDE.TIME"          // note the TI formatted path
#define TIPI_DATE_PATH "/PI/CLOCK"        // note the unix formatted path

// returns time from the ide controller -- recommend all programs use time_tm which will select an available clock automatically
struct tm *time_tm_ide ();              

// returns time from the myarc controller -- recommend all programs use time_tm which will select an available clock automatically
struct tm *time_tm_myarc ();

// returns time from tipi -- recommend all programs use time_tm which will select an available clock automatically
struct tm *time_tm_tipi ();

// returns the day of week for a given date
int get_day_of_week (int day, int month, int year);

// returns the day of year for a given date
int get_day_of_year (int day, int month, int year);

#endif
