/* utility_private.h
   change history
   05/31/2025 initial version
   06/02/2025 added copy_recursively to copy_with_remove
   06/03/2025 added file_examine_directory_query and file_remove_query.
              added user_query to dir_remove_contents_recursive in support of the rm command.
*/

#ifndef UTILITY_PRIVATE_H
#define UTILITY_PRIVATE_H

#include <batch_private.h>

typedef struct {
   char name[10];
   int type;
} entry_t;

typedef struct {
   entry_t entry[127];
   int count;
} dir_t;

int file_clone (const char *path_source, const char *path_target, int file_type);

int dir_remove_contents_recursive (batch_t *batch, const char *path_source, bool user_query);

int dir_copy_contents_recursive (batch_t *batch, const char *path_source, const char *path_target);

bool file_overwrite_query (const char *path);
bool file_examine_directory_query (const char *path);
bool file_remove_query (const char *path);

int copy_with_remove (const char *program_name, bool remove_after_copy, bool copy_recursively, batch_t *batch, const char *path_source, const char *path_target, bool overwrite_files, bool interactive_overwrite, bool verbose);

#endif
