/* rt.h
   This header defines the methods for basic (near) real-time capabilities.
   change log:
   07/01/2023 initial version
*/

#ifndef RT_H
#define RT_H

// 60 cycles / second (1/60 Hz)
#define RT99_CYCLES 60

// prototype for methods to be scheduled
typedef void rt99_method_t ();

// initialize rt99
void rt99_init ();

// add a method to rt99
void rt99_add_method (rt99_method_t *method, int minor_cycle);

// exits the scheduler
void rt99_sched_exit ();

// run the rt99 scheduler
void rt99_sched_run ();

#endif
