/* sequencer.h
   This header defines the methods for the sequencer which executes when the system is
   idle. Idleness is detected during requests for user input.
   change log:
   10/22/2023 methods moved from private definition
   11/23/2023 added comments
*/

#ifndef SEQUENCER_H
#define SEQUENCER_H

// adds a method to the sequencer
int sequencer_add (void (*function) (void));

// removes a method from the sequencer
int sequencer_remove (void (*function) (void));

// adds throttling to the seqeuncer
// DEPRECATED: this method will be removed after the system timer usage is fully integrated
void sequencer_set_throttle (int t);

#endif
