/* soundqueue.h
   This header defines the methods for sound capability with all sound play and
   management handled by the underlying runtime.
   change log:
   07/01/2023 initial version
   09/29/2023 added soundqueue_stop()
*/

#ifndef SOUNDQUEUE_H
#define SOUNDQUEUE_H

#include <stdbool.h>

// plays the honk sound
void soundqueue_honk ();

// plays the beep sound
void soundqueue_beep ();

// plays the tipi beep sounds
void soundqueue_tipi ();

// advanced playback rules
#define SOUNDQUEUE_PREEMPTION_RULE_ABORT    0   // indicates a sound should be aborted when another sound is played
#define SOUNDQUEUE_PREEMPTION_RULE_CONTINUE 1   // indicates a sound sound resume after a preempting sound has concluded

// loads a sound sequence in preparation for being played and returns a handle
int soundqueue_load (char *saddr, int len, int preemption_rule);

// plays a loaded sound sequence by handle
void soundqueue_play (int h);

// stops all sound
void soundqueue_stop ();

// returns true if sound play is done
bool soundqueue_play_is_done ();

#endif
