/* statfs.h
   This header defines the methods for statusing file systems.
   limitations:
   change log:
   07/01/2023 initial version
   12/10/2023 updated to use FILENAME_MAX for volume name
*/

#ifndef STATFS_H
#define STATFS_H

// statfs structure
struct statfs {
   char volume[FILENAME_MAX]; // volume name
   double f_blocks;           // total data blocks in filesystem
   double f_bfree;            // free blocks in filesystem
};

// provides file system status
int statfs (const char *path, struct statfs *buf);

#endif
