/* stdlib.h
   This header defines the standard library methods.
   change log:
   07/01/2023 initial version
   11/03/2023 added system method
   11/15/2023 added calloc
   11/23/2023 added comments for methods not previously commented
   05/17/2025 added rand, srand and RAND_MAX
*/

#ifndef STDLIB_H
#define STDLIB_H

#define RAND_MAX 65535

// returns the absolute value of an integer
int abs (int x);

// returns the absolute value of a long
long labs (long x);

// converts a string to an integer
int atoi (const char *str);

// converts a string to a long
long atol (const char *str);

// allocates an object from the heap 
void *malloc (int size);

// allocates count number of objects of size size contigously within the heap
void *calloc (int count, int size);

// frees a previously allocated heap object
void free (void *ptr);

// adds a method to be execute at program exit (after main ends)
int atexit (void (*function) (void));

// calls for the near-immediate termination of a program, allowing for atexit methods to be called and closing all open files
void exit (int status);

// calls for the immediate termination of a program
void _Exit (int status);

// converts an ascii representation of a float to a float
double atof (const char *a);

// quicksort
void qsort (void *base, int nitems, int size, int (*compar)(const void *, const void*));

// executes shell type commands
int system (const char *command);

// gets a password
char *getpass (const char *prompt);

// pseudo-random number generator (16-bit LCG)
unsigned int rand ();

// seed the random number
void srand (unsigned int s);

#endif
