/* string.h
   This header defines standard string handling methods.
   change log:
   07/01/2023 initial version
   08/11/2023 added strtok_mbseps
   08/20/2023 added strtok_f
   08/20/2023 removed strtok_mbseps and strtok_f. Added strsep
   11/15/2023 added strncmp
   12/10/2023 renamed to string.h
              migrated libti99 string functions
   05/19/2025 added strrchr
   06/16/2025 added strpbrk
*/

#ifndef STRING_H
#define STRING_H

// strlen - returns the length of a zero terminated string
int strlen (const char *s);

// copy a zero-terminated string from s to d, returns d
char *strcpy (char *d, const char *s);

// copy a zero-terminated string from s to d, max len, returns d
char *strncpy (char *d, const char *s, int len);

// compare two zero-terminated strings, return >0 if s1 is greater,
// <0 if s2 is greater, or 0 if the strings are equal
int strcmp (const char *s1, const char *s2);

// compare two memory blocks, return >0 if s1 is greater,
// <0 if s2 is greater, or 0 if the blocks are equal
int memcmp (const void *s1, const void *s2, int n);

// copy a block of memory from src to dest, of cnt bytes. Returns dest.
void *memcpy (void *dest, const void *src, int cnt);

// set a block of memory at dest to src, of cnt bytes. Returns dest.
void *memset (void *dest, int src, int cnt);

// concatenates a strong
char *strcat (char *dest, const char *add);

// concatenates a string, up to n characters
char *strncat (char *dest, const char *add, int n);

// searches for the first occurance of a character in a string
char *strchr (const char *s, int c);

// searches for the last occurance of a character in a string
char * strrchr (const char *s, int c);

// compares two strings ignoring case
int strcasecmp (const char *a, const char *b);

// compares two string up to n characters
int strncmp (const char *s1, const char *s2, int n);

// spans a string
int strcspn (char *string, char *chars);

// searches for one string within another
char *strstr (const char *haystack, const char *needle);

// searches for the first occurance of a character in charset in s; null if not found
char * strpbrk (const char *s, const char *charset);

// searches for one string within another, ignoring case
char *strcasestr (const char *haystack, const char *needle);

// locates tokens within a string
char *strtok (char *restrict str, const char *restrict sep);

// locates tokens within a string, returning every token even if zero length
char *strsep (char **stringp, const char *delim);

// skips over whitespace in a string
char *skip_whitespace (const char *s);

#endif
