/* shm.h
   This header defines the types and methods for shared memory.
   history 
   07/12/2025 initial version
   07/15/2025 added SHMLBA
*/

#ifndef SHM_H
#define SHM_H

#include <sys/ipc.h>
#include <stdio_private.h>

#define SHMLBA 4096

struct shmid_ds {
   int tbd;
};

int shmget (key_t key, long size, int shmflg);

void *shmat (int shmid, const void *shmaddr, int shmflg, int page);

int shmdt (const void *shmaddr);

int shmctl (int shmid, int cmd, struct shmid_ds *buf);

#endif
