/* stat.h
   This package provides stats on filesystem files.
   Change history
   05/21/2025 initial version
*/

#ifndef STAT_H
#define STAT_H

struct stat {
   long         st_size;
   unsigned int st_mode;
};

int S_ISDIR (unsigned int st_mode);

int S_ISREG (unsigned int st_mode);

int S_ISTIDISVAR (unsigned int st_mode);

int S_ISTIINTFIX (unsigned int st_mode);

int stat (const char *path, struct stat *buf);

int mkdir (const char *path, unsigned int mode);

#endif
