/* time.h
   This header defines the types and methods for time.
   change history
   06/13/2025 initial version
*/

#ifndef TIME_H
#define TIME_H

// struct tm
struct tm {
   int tm_sec;   // Seconds [0,60].
   int tm_min;   // Minutes [0,59].
   int tm_hour;  // Hour [0,23].
   int tm_mday;  // Day of month [1,31].
   int tm_mon;   // Month of year [0,11].
   int tm_year;  // Years since 1900.
   int tm_wday;  // Day of week [0,6] (Sunday =0).
   int tm_yday;  // Day of year [0,365].               
   int tm_isdst; // Daylight Savings flag.
}; 

// returns current, local time (non-standard--unix99 doesn't support the UTC time format due to lack of source)
struct tm *time_tm ();

// formats time into the requested format
int strftime (char *restrict s, int maxsize, const char *restrict format, const struct tm *restrict timeptr);

#endif
