/* unistd.h
   This header defines the methods for UNIX type command processing.
   change log:
   07/01/2023 initial version
   11/23/2023 added POSIX standard file numbers
   05/24/2025 added rmdir
   10/05/2025 added isatty
*/

#ifndef UNISTD_H
#define UNISTD_H

#define STDIN_FILENO    0       // standard input
#define STDOUT_FILENO   1       // standard output
#define STDERR_FILENO   2       // standard error output

// invokes a new command, effectively replacing the current program
int execv (const char *path, const char *argv[]);

// mostly compliant getopt argument processing method
extern int optind;
extern char *optarg;
int getopt (int argc, char * const argv[], const char *optstring);

// returns the current working directory
char *getcwd (char *buf, int size);

// changes the current working directory
int chdir (const char *path);

// returns the real user id
int getuid ();

// returns the login name of the user associated with the current session, as previously set by setlogin
char *getlogin ();

// sets the login name of the user associated with the current session to name
int setlogin (const char *name);

// gets the session id
int getsessionid ();

// sets the session id
int setsessionid (int id);

// removes a directory
int rmdir (const char *path);

// reboots the operating system
void reboot ();

// determines if a file is a tty or not
int isatty (int fd);

#endif
