/* utsname.h
   This header defines the methods required for retrieving system information.
   change log:
   11/02/2023 initial version
*/

#ifndef UTSNAME_H
#define UTSNAME_H

#define SYS_NMLN 65

struct utsname {
   char sysname[SYS_NMLN];    /* Operating system name (e.g., "Linux") */
   char nodename[SYS_NMLN];   /* Name within communications network to which the node is attached, if any */
   char release[SYS_NMLN];    /* Operating system release (e.g., "2.6.28") */
   char version[SYS_NMLN];    /* Operating system version */
   char machine[SYS_NMLN];    /* Hardware type identifier */
   char proc_arch[SYS_NMLN];  /* Machine processor architecture */
};

// retrieves system information
int uname (struct utsname *name);

#endif
