/* launchd.c
   This program initializes the system by running the scipts in /etc/rc.
   change log:
   12/26/2024 initial version
   01/04/2025 added code to set bar font
   01/18/2025 removed setting of the bar font since unix99r3 loads default fonts in rom 0
   01/20/2025 moved fputs to dylib.fputs
   09/14/2025 backed out updates for debugging
*/

#include <dylib.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <console_private.h>
#include <vdp.h>

int main (int argc, char *argv[]) {

   const char *program_name = "launchd";
   const char *rc_filename  = "/etc/rc";

   FILE *f;
   char cmds[256];
   char cmd[80];
   int r;

   f = dylib.fopen (rc_filename, "r");                 // open rc file
   if (f) {                                            // confirm file is open
      dylib.strcpy (cmds, "");                         // init the commands list
      while (dylib.fgets (cmd, sizeof (cmd), f)) {     // read all lines
         cmd[dylib.strcspn (cmd, "\r\n")] = ';';
         dylib.strcat (cmds, cmd);                     // concatenate the command
      }
      dylib.fclose (f);                                // close the rc file

      r = system (cmds);                               // execute the commands

      if (r) {                                         // test for error
         dylib.fputs (program_name, stdout);           // write error
         dylib.fputs (" failed to execute commands in ", stdout);
         dylib.fputs (rc_filename, stdout);
         dylib.fputs (".\n", stdout);
      }
   } else {                                            // error opening the rc file
      console_init ();                                 // initialize the console
      dylib.fputs (program_name, stdout);              // write an error
      dylib.fputs (" cannot read ", stdout);   
      dylib.fputs (rc_filename, stdout);
      dylib.fputs (".\n", stdout);
   }
   return 0;                                           // exit
}
