/* _Exit.c
   This method aborts the program terminating to the TI title screen.
   change log:
   01/17/2025 migrated form exit.c
   02/13/2025 added console_display_set_mode_legacy_parameters call
*/

#include <stdlib.h>
#include <sams_private.h>
#include <console_private.h>

void _Exit (int status) {
   console_display_set_mode_legacy_parameters ();          // turn off any non-legacy vdp features
   sams_reset ();                                          // clear the sams device back to its default state
   __asm__("BLWP @>0000");                                 // reboot to the console boot screen
   while (1);
}
