/* accts_add_user.c
   This method adds a user to an accounts object.
   change log:
   11/25/2023 initial version
   12/10/2023 removed reference to string_ext.h
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <stdlib.h>
#include <string.h>
#include <dylib.h>

int accts_add_user (accts_t *accts, const char *name, const char *cipher, const char *long_name) {
   int r = UNDEFINED;
   if (accts_get_username_index (accts, name) == UNDEFINED) {
      accts->acct[accts->count] = malloc (sizeof (acct_t));
      dylib.strcpy (accts->acct[accts->count]->name, name);
      dylib.strcpy (accts->acct[accts->count]->cipher, cipher);
      accts->acct[accts->count]->uid = accts_get_next_uid (accts);
      accts->acct[accts->count]->gid = 0;
      dylib.strcpy (accts->acct[accts->count]->long_name, long_name);
      dylib.strcpy (accts->acct[accts->count]->home_dir, "/home/");
      dylib.strcat (accts->acct[accts->count]->home_dir, name);
      dylib.strcpy (accts->acct[accts->count]->shell, "/bin/sh");
      accts->count++;
      r = 0;
   }
   return r;
}
