/* accts_get_next_uid.c
   This method returns the next available user id for the accounts object.
   change log:
   11/25/2023 initial version
   12/10/2023 changed reference to math.h
*/

#include <accts_private.h>
#include <math.h>

int accts_get_next_uid (const accts_t *accts) {
   int r = 0;
   for (int i = 0; i < accts->count; i++) {
      r = max (accts->acct[i]->uid, r);
   }
   if (r < 1000) {
      r = 1000;
   }
   r++;
   return r;
}
