/* accts_get_username_index.c
   This method returns the index of the username within an accounts object.
   change log:
   11/25/2023 initial version
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <string.h>
#include <dylib.h>

int accts_get_username_index (const accts_t *accts, const char *name) {
   int r = UNDEFINED;
   for (int i = 0; i < accts->count; i++) {
      if (!dylib.strcmp (accts->acct[i]->name, name)) {
         r = i;
         break;
      }
   }
   return r;
}
