/* accts_get_value.c
   This method returns a string or integer value for the specified field for a given user in an accounts object.
   change log:
   11/25/2023 initial version
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <string.h>
#include <dylib.h>

int accts_get_value (accts_t *accts, const char *name, int field_id, char *value_s, int *value_i) {
   int r = UNDEFINED;
   int k = accts_get_username_index (accts, name);
   if (k >= 0) {
      dylib.strcpy (value_s, "");
      *value_i = 0;
      r = 0;
      switch (field_id) {
         case PASSWD_LOGIN:
            dylib.strcpy (value_s, accts->acct[k]->name);
            break;
         case PASSWD_CIPHER:
            dylib.strcpy (value_s, accts->acct[k]->cipher);
            break;
         case PASSWD_UID:
            *value_i = accts->acct[k]->uid;
            break;
         case PASSWD_GID:
            *value_i = accts->acct[k]->gid;
            break;
         case PASSWD_NAME:
            dylib.strcpy (value_s, accts->acct[k]->long_name);
            break;
         case PASSWD_HOMEDIR:
            dylib.strcpy (value_s, accts->acct[k]->home_dir);
            break;
         case PASSWD_SHELL:
            dylib.strcpy (value_s, accts->acct[k]->shell);
            break;
         default:
            r = UNDEFINED;
            break;
      }
   }
   return r;
}
