/* accts_read.c
   This method reads the password file and loads into an accounts object
   change log:
   11/25/2023 initial version
   12/10/2023 removed reference to string_ext.h
   02/27/2024 added use of dylib
   03/01/2024 more use of dylib
   10/11/2025 augmented to use strsep over strtok so that fields can be blank
*/

#include <accts_private.h>
#include <constants.h>
#include <string.h>
#include <stdlib.h>
#include <dylib.h>

int accts_read (accts_t *accts) {
   int r = UNDEFINED;
   FILE *f = dylib.fopen (accts_get_passwd_file_path (), "r");    // open the password file
   if (f) {                                                       // confirm the file opened successfully
      char s[80];
      char *k = s;
      while (dylib.fgets (s, sizeof (s), f)) {                    // loop through all lines in the file, retrieving each
         s[dylib.strcspn (s, "\r\n")] = 0x00;                     // remove cr/lf
         accts->acct[accts->count] = malloc (sizeof (acct_t));
         k = s;
         dylib.strcpy (accts->acct[accts->count]->name, strsep (&k, ":"));
         dylib.strcpy (accts->acct[accts->count]->cipher, strsep (&k, ":"));
         accts->acct[accts->count]->uid = atoi (strsep (&k, ":"));
         accts->acct[accts->count]->gid = atoi (strsep (&k, ":"));
         dylib.strcpy (accts->acct[accts->count]->long_name, strsep (&k, ":"));
         dylib.strcpy (accts->acct[accts->count]->home_dir, strsep (&k, ":"));
         dylib.strcpy (accts->acct[accts->count]->shell, strsep (&k, ":"));
         accts->count++;
      }
      dylib.fclose (f);                                           // close the file
      r = 0;
   }
   return r;
}
