/* accts_rm_user.c
   This method removes a user from an accounts object.
   change log:
   11/25/2023 initial version
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <string.h>
#include <stdlib.h>
#include <dylib.h>

int accts_rm_user (accts_t *accts, const char *name) {
   int r = UNDEFINED;
   if (dylib.strcmp (name, "root")) {
      int di = accts_get_username_index (accts, name);
      if (di >= 0) {
         if (di != accts->count - 1) {
            acct_t *d = accts->acct[di];
            acct_t *s = accts->acct[accts->count - 1];
            accts->acct[di] = s;
            accts->acct[accts->count - 1] = d;
         }
         free (accts->acct[accts->count - 1]);
         accts->count--;
         r = 0;
      }
   }
   return r;
}
