/* accts_set_value.c
   This method sets a string or integer value for the field for a user within an accounts object.
   change log:
   11/25/2023 initial version
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <string.h>
#include <dylib.h>

int accts_set_value (accts_t *accts, const char *name, int field_id, const char *value_s, int value_i) {
   int r = UNDEFINED;
   int k = accts_get_username_index (accts, name);
   if (k >= 0) {
      r = 0;
      switch (field_id) {
         case PASSWD_LOGIN:
            dylib.strcpy (accts->acct[k]->name, value_s);
            break;
         case PASSWD_CIPHER:
            dylib.strcpy (accts->acct[k]->cipher, value_s);
            break;
         case PASSWD_UID:
            accts->acct[k]->uid = value_i;
            break;
         case PASSWD_GID:
            accts->acct[k]->gid = value_i;
            break;
         case PASSWD_NAME:
            dylib.strcpy (accts->acct[k]->long_name, value_s);
            break;
         case PASSWD_HOMEDIR:
            dylib.strcpy (accts->acct[k]->home_dir, value_s);
            break;
         case PASSWD_SHELL:
            dylib.strcpy (accts->acct[k]->shell, value_s);
            break;
         default:
            r = UNDEFINED;
            break;
      }
   }
   return r;
}
