/* accts_write.c
   This method writes an accounts object to the passwd file.
   change log:
   11/25/2023 initial version
   02/27/2024 added use of dylib
*/

#include <accts_private.h>
#include <constants.h>
#include <dylib.h>

int accts_write (const accts_t *accts) {
   int r = UNDEFINED;
   FILE *f = dylib.fopen (accts_get_passwd_file_path (), "w");
   if (f) {
      accts_write_raw (accts, f);
      dylib.fclose (f);
      r = 0;
   }
   return r;
}
