/* accts_write_raw.c
   This method writes an accounts object to the specified stream.
   change log:
   11/25/2023 initial version
   12/10/2023 added reference to conversion.h
   03/01/2024 updated to string constants rather than literals in calls to dylib.fputs to prevent compiler translation to fwrite
              modified to use dylib
   01/20/2025 updated fputs to dylib
*/

#include <accts_private.h>
#include <string.h>
#include <conversion.h>
#include <dylib.h>

void accts_write_raw (const accts_t *accts, FILE *f) {
   const char *sep = ":";
   const char *cr  = "\n";

   for (int i = 0; i < accts->count; i++) {
      dylib.fputs (accts->acct[i]->name, f);
      dylib.fputs (sep, f);
      dylib.fputs (accts->acct[i]->cipher, f);
      dylib.fputs (sep, f);
      dylib.fputs (dylib.int2str (accts->acct[i]->uid), f);
      dylib.fputs (sep, f);
      dylib.fputs (dylib.int2str (accts->acct[i]->gid), f);
      dylib.fputs (sep, f);
      dylib.fputs (accts->acct[i]->long_name, f);
      dylib.fputs (sep, f);
      dylib.fputs (accts->acct[i]->home_dir, f);
      dylib.fputs (sep, f);
      dylib.fputs (accts->acct[i]->shell, f);
      dylib.fputs (cr, f);
   }
}
