/* assert_handle.c
   change log:
   12/10/2023 added header
   03/01/2024 modified to use dylib
              modified to use string constants for dylib.fputs
   01/20/2025 updated fputs to dylib
*/ 

#include <conversion.h>
#include <stdio.h>
#include <console.h>
#include <assert_private.h>
#include <dylib.h>

int assert_handle (char *file, int line, char *expression) {
   dylib.fputs ("\nassert (", stderr);
   dylib.fputs (expression, stderr);
   dylib.fputs (") failed,\nfile ", stderr);
   dylib.fputs (file, stderr);
   dylib.fputs (" line ", stderr);
   dylib.fputs (dylib.int2str (line), stderr);
   dylib.fputs ("\npress A to acknowledge", stderr);

   while (console_getc () != 65);
   return 1;
}
