/* atexit.c
   This method is used to add other methods to be called at program exit
   change log:
   01/17/2025 migrated from exit.c
*/

#include <constants.h>
#include <stdlib.h>
#include <cache_private.h>

int atexit (void (*function) (void)) {
   int r = UNDEFINED;                                               // set to failed
   if (cache.atexit_info.count < ATEXIT_MAX) {                      // ensure this new entry doesn't exceed the max count
      cache.atexit_info.method[cache.atexit_info.count] = function; // add the function
      cache.atexit_info.count++;                                    // increase the count
      r = 0;                                                        // set to success
   }
   return r;                                                        // return the result
}
