/* atoi.c
   This method converts a number in text format to an integer.
   change log:
   12/10/2023 added header
   05/23/2025 corrected bug for -32768 that returns 0
*/ 

#include <stdlib.h>

int atoi (const char *str) {
   unsigned int old_uint;                   // temp value
   unsigned int out_uint = 0;               // initialize the collection value
   int out_int           = 0;               // the return value
   int neg               = 0;               // negative flag
   char *s               = (char *) str;    // processing pointer
 
   while ((*s <= ' ') && (*s != '\0')) ++s; // skip whitespace
  
   if (*s == '-') {                         // determine if value will be negative
      ++s;                                  // skip over
      neg = 1;                              // set the negative flag
   }

   if (*s == '+') ++s;                      // ignore and skip over positive symbol

   while ((*s >= '0') && (*s <= '9')) {     // process digits
      old_uint  = out_uint;
      out_uint *= 10;
      out_uint += (*s)-'0';
      ++s;
      if (out_uint < old_uint) {            // confirm wrap around didn't occur
         out_uint = 0;
         break;
      }
   }

   if (out_uint <= 32767) {                 // the regular case, -32767 to 32767
      out_int = out_uint;                   // set the return value
      if (neg) {                            // if negative, negate the value
          out_int = -out_int;              
      }
   } else if (out_uint == 32768 && neg) {   // special case of -32767  
      out_int = -32768;
   }
      
   return out_int;                          // return the result
}

