/* atol.c
   This method converts a string to a long.
   change log:
   01/03/2024 initial version
*/ 

#include <stdlib.h>

long atol (const char *str) {
   long old;
   long out    = 0;
   long negpos = 1;
   char *s     = (char *) str;
 
   // skip whitespace
   while ((*s <= ' ') && (*s != '\0')) ++s;
  
   if (*s == '-') {
      ++s;
      negpos = -1;
   }
   if (*s == '+') ++s;

   // check whole digits
   while ((*s >= '0') && (*s <= '9')) {
      old = out;
      out *= 10;
      out += (*s)-'0';
      ++s;
      if (out < old) {
         // too big, wrapped around
         return 0;
      }
   }

   out *= negpos;

   return out;
}
