/* basename.c
   This method returns the last component of the pathname pointed to by path.
   This method returns the last component from the pathname pointed to by path, deleting any trailing ‘/’ characters.  If path 
   consists entirely of ‘/’ characters, a pointer to the string "/" is returned.  If path is a null pointer or the empty string, 
   a pointer to the string "./" is returned.
   change log:
   11/03/2023 initial version
   11/21/2023 updated to use FILENAME_MAX
   03/01/2024 updated to use dylib
   05/24/2025 corrected issue where a short path, such as /bin would return /. There was a stray setting of / position to 0, when
              occuring at the first position, resulted in the string being length 0 and then a special case kicked in.
*/

#include <libgen.h>
#include <stdio.h>
#include <string.h>
#include <dylib.h>

char * basename (char *path) {
   static char ipath[FILENAME_MAX];
   bool found_slash;
   char *r = NULL;

   if (path) {                    
      dylib.strcpy (ipath, path);

      // kill off trailing slashes
      int len = dylib.strlen (ipath);
      found_slash = false;
      for (int i = len - 1; i >= 0; i--) {
         if (ipath[i] == '/') {
            found_slash = true;
            ipath[i]    = 0x00;
         } else {
            break;
         }
      }

      if (!dylib.strlen (ipath) && found_slash) {
         r = "/";
      } else {

         int len = dylib.strlen (ipath);
         found_slash = false;
         for (int i = len - 1; i >= 0; i--) {
            if (ipath[i] == '/') {
               found_slash = true;
//             ipath[i]    = 0x00;
               r           = &ipath[i] + 1;
               break;
            } else {
               r           = &ipath[i];
            }
         }
         if (!dylib.strlen (ipath)) {
            if (found_slash) {
               r = "/";
            } else {
               r = "./";
            }
         }
      }
   } else {
      r = "./";
   }

   return r;
}
