/* basic_at.c
   These methods implement the basic display/accept "at" functionality.
   change history
   11/27/2025 initial version
*/

#include <basic.h>
#include <console.h>

static int basic_restore_y;
static int basic_restore_x;

void at (int y, int x) {
   console_get_pos (&basic_restore_x, &basic_restore_y); // current position to be restored after the display/accept concludes
   console_set_pos (x, y);                               // set the user specified position
}

void atend () {
   console_set_pos (basic_restore_x, basic_restore_y);   // restore the screen position after the display/accept concludes
}
