#include <basic.h>
#include <string.h>
#include <dylib.h>
#include <stdlib.h>

basic_file_t basic_file[BASIC_FILES_MAX];

void basic_files_init () {
   memset (&basic_file, 0x00, sizeof (basic_file));
}

void basic_file_read_data (int index) {
   dylib.strcpy (basic_file[index].s.val, "");
   dylib.fgets (basic_file[index].s.val, CSTRING_LEN, basic_file[index].f);
   basic_file[index].s.val[strcspn (basic_file[index].s.val, "!\r\n")] = 0x00;  // kill of CR and LF
}

void basic_file_open (int id, string_t name, int mode) {
   const char *basic_file_mode[3] = {"r", "w", "a"};

   int r = 1;
   for (int i = 0; i < BASIC_FILES_MAX; i++) {
      if (!basic_file[i].in_use) {
         basic_file[i].f      = dylib.fopen (name.val, basic_file_mode[mode]);
         if (basic_file[i].f) {
            basic_file[i].id     = id;
            basic_file[i].in_use = true;
            if (!mode) {   // if the file is being opened for reading, read the first line so EOF will be triggered ahead of
                           // the basic program input call
               basic_file_read_data (i);
            }
            r = 0;
         }
         break;
      }
   }
   if (r) {
      fprintf (stdout, "cannot open file %s id %d\n", name, id);
      exit (0);
   }
}

int basic_file_get_index (int id) {
   int r = -1;
   for (int i = 0; i < BASIC_FILES_MAX; i++) {
      if (basic_file[i].in_use && basic_file[i].id == id) {
         r = i;
         break;
      }
   }
   if (r < 0) {
      fprintf (stdout, "file id %d not open\n", id);
      exit (0);
   }
   return r;
}

FILE *basic_file_get_stream (int id) {
   return basic_file[basic_file_get_index (id)].f;
}

void basic_file_close (int id) {
   int i = basic_file_get_index (id);
   dylib.fclose (basic_file[i].f);
   basic_file[i].in_use = false;
}

void basic_file_input (int id, string_t *s) {
   int i = basic_file_get_index (id);
   dylib.strcpy (s->val, basic_file[i].s.val);
   basic_file_read_data (i);
}

int eof (int id) {
   int r = 1;
   int i = basic_file_get_index (id);
   r = basic_file[i].f->eof;
   return r;
}
