/* basic_hchar.c
   This method implements the basic hchar capability.
   change history
   11/22/2025 initial version
*/

#include <basic.h>
#include <vdp.h>
#include <console.h>
#include <math.h>

void hchar (int y, int x, int c, int count) {

   int rows, cols;
   unsigned int addr;

   console_get_window_size (&rows, &cols);

   addr  = y * cols + x;
   count = min (count, rows * cols - addr);

   vdpmemset (addr, c, count);
}
