/* basic_pos.c
   This method implements the basic pos capability.
   change history
   11/22/2025 initial version
*/

#include <basic.h>
#include <string.h>

int pos (string_t src, string_t sub, int start) {
   int r;
   int src_len = strlen (src.val);
   int sub_len = strlen (sub.val);
   if (start < 1 || start > src_len || sub_len == 0) {
      r = 0;
   } else {
      char *found = strstr (src.val + (start - 1), sub.val);
      if (!found) {
         r = 0;
      } else {
         r = (int)(found - src.val) + 1;
      }
   }
   return r;
}
