/* basic_rpt.c
   This method implements the basic rpt capability.
   change history
   11/22/2025 initial version
*/

#include <basic.h>
#include <string.h>

string_t rpt (string_t src, int count) {
   string_t r;
   int src_len = strlen (src.val);
   if (count <= 0 || !src_len) {
      strcpy (r.val, "");
   } else {
      int total_len = src_len * count;
      if (total_len > sizeof (string_t) - 1) {
         total_len = sizeof (string_t) - 1;
      }
      char* p = r.val;
      int j = 0;
      for (int i = 0; i < total_len; i++) {
         *p = src.val[j];
         p++;
         j++;
         if (j >= src_len) {
            j = 0;
         }
      }
      *p = 0x00;
   }
   return r;
}
