/* basic_seg.c
   This method implements the basic seg capability.
   change history
   11/22/2025 initial version
*/

#include <basic.h>
#include <string.h>

// return a string segment
string_t seg (string_t src, int start, int length) {
   string_t r;
   int src_len = strlen (src.val);
   int pos = start - 1;
   if (pos < 0 || pos >= src_len || length <= 0) {
      strcpy (r.val, "");
   } else {
      if (pos + length > src_len) {
         length = src_len - pos;
      }
      strncpy (r.val, src.val + pos, length);
      r.val[length] = 0x00;
   }
   return r;
}
