/* basic_vchar.c
   This method implements the basic vchar capability.
   change history
   11/22/2025 initial version
*/

#include <basic.h>
#include <vdp.h>
#include <console.h>
#include <math.h>
#include <conversion.h>

void vchar (int y, int x, int c, int count) {

   int rows, cols;                                           // get the display size
   console_get_window_size (&rows, &cols);

   count = min (count, (cols - x - 1) * rows + rows - y);    // cap the count to the end of the screen

   int rem_rows = rows;
   int width;
   int yt;

   unsigned int addr = y * cols + x;                         // calculate the initial screen address

   for (yt = y; (yt < rows) && count; yt++) {                // loop from the first row until the end of the screen; break if no more to write
      width = (count - 1) / rem_rows + 1;                    // calculate the width of this particular write
      vdpmemset (addr, c, width);                            // perform the write
      count -= width;                                        // subtract the width of the write from the remaining count
      addr   += cols;                                        // move to the next address
      rem_rows--;                                            // reduce the number of rows
   }

   addr = x + 1;                                             // move back to the top of the screen

   for (yt = 0; (yt < y) && count; yt++) {                   // loop from the top row to the y-1 position; break if no more to write
      width = (count - 1) / rem_rows + 1;                    // repeat as above
      vdpmemset (addr, c, width);
      count -= width;
      addr   += cols;
      rem_rows--;
   }
}
