/* batch_create.c
   This method creates a batch file.
   change history
   06/02/2025 initial version
   06/03/2025 added recursive verbosity support
*/

#include <batch_private.h>
#include <dylib.h>
#include <stdio.h>

batch_t batch_create (const char *path, bool summary_verbose, bool recursive_verbose, bool debug) {
   batch_t batch;
   dylib.strcpy (batch.path, path);
   batch.summary_verbose   = summary_verbose;
   batch.recursive_verbose = recursive_verbose;
   batch.debug   = debug;
   batch.f       = dylib.fopen (batch.path, "wb");
   return batch;
}
