/* batch_execute.c
   This method executes a batch file.
   change history
   06/02/2025 initial version
   06/03/2025 updated the note command to support single parameters
   06/15/2025 modified to call remove_file rather than remove
              added break out on failure
*/

#include <batch_private.h>
#include <dylib.h>
#include <utility_private.h>
#include <dsrl2_private.h>
#include <stdlib.h>
#include <stdio_private.h>

int batch_execute (batch_t *batch) {
   char s[128];
   int r = 0;
   char *cmd;
   char *param1;
   char *param2;
   char *file_type;

   batch->f = dylib.fopen (batch->path, "rb");
   if (batch->f) {
      while (dylib.fgets (s, sizeof (s), batch->f)) {
         if (batch->debug) {
            dylib.fputs (s, stdout);
         }
         cmd       = dylib.strtok (s, " \n");
         param1    = dylib.strtok (NULL, " \n");
         param2    = dylib.strtok (NULL, " \n");
         file_type = dylib.strtok (NULL, " \n");
         if (!dylib.strcmp (cmd, "cp")) {
            r = file_clone (param1, param2, atoi (file_type));
         } else if (!dylib.strcmp (cmd, "rm")) {
            r = remove_file (param1);
         } else if (!dylib.strcmp (cmd, "frename")) {
            r = dsrl2_rename_file (param1, param2);
         } else if (!dylib.strcmp (cmd, "mkdir")) {
            r = dsrl2_mkdir (param1);
         } else if (!dylib.strcmp (cmd, "rmdir")) {
            r = dsrl2_rmdir (param1);
         } else if (!dylib.strcmp (cmd, "drename")) {
            r = dsrl2_rename_directory (param1, param2);
         } else if (!dylib.strcmp (cmd, "note")) {
            dylib.fputs (param1, stdout);
            if (param2) {
               dylib.fputs (" -> ", stdout);
               dylib.fputs (param2, stdout);
            }
            dylib.fputs ("\n", stdout);
         } else {
            dylib.fputs ("batch_error!\n", stdout);
         }

         if (r) {
            dylib.fputs ("batch error: ", stderr);
            dylib.fputs (cmd, stderr);
            dylib.fputs (", ", stderr);
            dylib.fputs (param1, stderr);
            if (param2) {
               dylib.fputs (", ", stderr);
               dylib.fputs (param2, stderr);
            }
            dylib.fputs ("\n", stderr);
            break;
         }
      }
      dylib.fclose (batch->f);
   } else {
      r = 1;
   }
   return r;
}
