/* batch_cp.c
   This method batches for a file copy.
   change history
   06/02/2025 initial version
*/

#include <batch_private.h>
#include <dylib.h>

void batch_file_cp (batch_t *batch, const char *source, const char *target, int file_type) {
   dylib.fputs ("cp ", batch->f);
   dylib.fputs (source, batch->f);
   dylib.fputs (" ", batch->f);
   dylib.fputs (target, batch->f);
   dylib.fputs (" ", batch->f);
   dylib.fputs (dylib.int2str (file_type), batch->f);
   dylib.fputs ("\n", batch->f);
}
