/* batch_note.c
   This method batches for a user message.
   change history
   06/02/2025 initial version
   06/03/2025 modified for recursive verbosity support
*/

#include <batch_private.h>
#include <dylib.h>

void batch_note (batch_t *batch, const char *source, const char *target) {
   if (batch->summary_verbose) {
      dylib.fputs ("note ", batch->f);
      dylib.fputs (source, batch->f);
      dylib.fputs (" ", batch->f);
      dylib.fputs (target, batch->f);
      dylib.fputs ("\n", batch->f);
   }
}
