/* cache_init.c
   This method initializes the cache if it is not already initialized.
   change log:
   08/11/2023 initial version
   08/11/2023 added splash_displayed to cache def
   11/03/2023 removed splash_displayed
   11/06/2023 added login initialization
   11/16/2023 added rom_cache_init
              added dsr_cache_init
              improved documentation
   02/17/2024 moved the cache to a separate file to eliminate linking in all the init methods into all EA5 programs
   02/18/2024 added dylib_init and dsr_list_init
   02/24/2024 added call for memset and commented out all methods just simply zero out their associated values
   01/04/2025 updated to determine if the SAMS memory card is installed by testing the screen contents at VDP 0x0020.
   01/07/2025 removed cache validity flag
   01/12/2025 updated sams exists to sams page count
   01/18/2025 added dir_init to the comments for items that are already initialized to the correct state by the memset
              capture the sams page count from 0xa800
   01/22/2025 performance improvements
   01/25/2025 modified for sams_status_t
   04/10/2025 added setting of sram expansion flag
   07/05/2025 updated to capture the SAMS page count from SRAM
*/

#include <cache_private.h>
#include <sram_private.h>
#include <string.h>
#include <vdp.h>
#include <signal_private.h>

void cache_init () {

   memset (&cache, 0x00, sizeof (cache));

   /* these items are automatically initialized by the above memset:

      cache.num_kvs = 0;                    // initialize the # of keys
      dsr_list_init ();                     // init the dsr list
      dsr_hardware_init ();                 // init the dsr hardware readiness flag
      rom_cache_init ();                    // init the rom cache
      proc_cache_init ();                   // init the process cache
      dir_init ();                          // init the directory data

   */

   volatile int *v = (volatile int *) 0x8320;
   cache.sams.page_count = *v;

   cachex.sram_is_expanded = sram_get_size () == 1024;

   // initialize the console cache
   console_cache_init ();

   login_cache_init ();                     // init the login cache
}
