/* cache_put.c
   This method caches a value for a key.
   change log:
   11/03/2023 initial version
   02/24/2024 updated to write to cache as a regular variable rather than a pointer
*/

#include <cache.h>
#include <cache_private.h>
#include <constants.h>

int cache_put (int key, int val) {
   int r = UNDEFINED;
   for (int i = 0; i < cache.num_kvs; i++) {
      if (cache.kv[i].key == key) {
         cache.kv[i].val = val;
         r                = 0;
         break;
      }
   }
   if (r == UNDEFINED && cache.num_kvs < MAX_KV_ENTRIES) {
      cache.kv[cache.num_kvs].key = key;
      cache.kv[cache.num_kvs].val = val;
      cache.num_kvs++;
      r                             = 0;
   }
   return r;
}
