/* cat.c
   This method implements the file concatenation functionality.
   change log:
   07/01/2023 initial version
   07/10/2023 updated to display error for files that cannot be opened
   08/20/2023 modified to use fputs rather than fprintf (also available in dylib as of 01/20/2025)
   11/03/2023 removed key cancelling
   12/10/2023 removed reference to string_ext.h
   02/29/2024 modified to use dylib
              modified to return the status
   01/20/2025 updated fputs to dylib
   06/08/2025 updated to call cat_handle
*/

#include <util.h>
#include <stdio.h>
#include <dylib.h>

int cat (const char *filename) {
   int r = -1;

   FILE *f = dylib.fopen (filename, "r");
   if (f) {
      cat_handle (f);
      dylib.fclose (f);
      r = 0;
   }
   
   return r;
}
