/* cat_words.c
   This method performs the file concatenation function while also eliminating word-wrap.
   change log:
   06/23/2023 initial version
   12/10/2023 removed reference to string_ext.h
   10/04/2025 corrected ioctl.h ref
*/

#include <string.h>
#include <stdio.h>
#include <stdbool.h>
#include <assert.h>
#include <console.h>
#include <sys/ioctl.h>

void cat_words (const char *filename) {
   const char *sep = " ";
   int k;
   char s[256];
   bool do_continue = true;
   int len;
   
   char *tok;
   struct winsize w;
   ioctl (fileno (stdout), TIOCGWINSZ, &w);

   FILE *f = fopen (filename, "r");
   assert (f);
 
   if (f) {
      while (fgets (s, sizeof (s), f)) {
//       s[strlen (s) - 1] = 0;                               // kill off the line feed
         s[strcspn(s, "\r\n")] = 0;                           // remove CR/LF
         len = 0;
         tok = strtok (s, sep);                               // grab the first token
         while (tok) {                                        // continue while there is a token
            if ((strlen (tok) + len) >= w.ws_col) {           // if the token won't fit on the line then move to the
               fprintf (stdout, "\n");                        // output the next line feed
               len = 0;                                       // reset width back to zero
            }
            if (len == 0) {                                   // handle first word vs second and subsequent
               fprintf (stdout, "%s", tok);                   // just output the token itself
               len += strlen (tok);
            } else {
               fprintf (stdout, " %s", tok);                  // output a space followed by the token
               len += strlen (tok) + 1;
            }
            tok = strtok (NULL, sep);                         // get the next token
         }
         fprintf (stdout, "\n");                              // output the final line feed
         k = console_get_key ();                               // printing and wait for a key
         do_continue = ((k != 'c') && (k != 'C'));            // assess the key and determine if the user wants to
         if (!do_continue) break;                             // exit if user has pressed c
      }
   }

   fclose (f);
}
