/* chdir.c
   This method changes the current working directory.
   change log:
   08/05/2023 initial version
   08/14/2023 updated for unix paths
   11/03/2023 added call to write the cwd to the disk
   11/21/2023 updated to use cache
              updated to use FILENAME_MAX
   02/24/2024 broad changes for cache and dylib
   02/29/2024 added calling generate_unix_path via dylib
   03/07/2024 updated to use dylib's getcwd
*/

#include <constants.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <unistd_private.h>
#include <cache_private.h>
#include <dylib.h>

int chdir (const char *path) {
   int r = UNDEFINED;                                // set to failed
   DIR *d;                                           // allocate a directory file
 
   d = opendir (path);                               // open the directory to verify it is valid
   if (d) {                                          // check it exists
      closedir (d);                                  // close the directory (it was opened successfully, and 
                                                     // thus is a valid directory)

      // capture the final / absolute path
      char cwd[FILENAME_MAX];
      dylib.getcwd (cwd, sizeof (cwd));
      bool final_path_ok;
      char final_path[FILENAME_MAX];
      dylib.generate_unix_path (cwd, (char *) path, &final_path_ok, final_path);

      dylib.strcpy (cache.login.cwd, final_path);    // copy new directory to the cwd
      r = 0;                                         // set to success
   }
   return r;                                         // return the result
}
