#include <cipher.h>
#include <cipher_private.h>
#include <string.h>
#include <dylib.h>

// decrypts the vic cipher
int cipher_vic_decrypt (char *plaintext, const char *cipher, int len) {

   int r;                                      // return value
   int i;                                      // loop var
   int j;                                      // cipher position
   int c;                                      // map column
   char v;                                     // decrypted single character

   const int cipher_len = dylib.strlen (cipher);     // get the length of the cipher
 
   if (cipher_len / 2 < len - 1) {             // ensure there's space to store the decrypted cipher

      for (i = 0; i < cipher_len; i += 2) {    // loop through the cipher 2 characters at a time
         j = i;                                // capture the first position
         if (cipher[j] <= '9') {               // convert from ASCII hex representation to an int value
            c = cipher[j] - '0';
         } else {
            c = cipher[j] - 'A' + 10;
         }
         j++;                                  // move to the next cipher position

         v = cipher_vic_map[c] << 4;           // migrate this decrypted nibble into the final decrypted character value

         if (cipher[j] <= '9') {               // convert from ACII hex representation to an int value
            c = cipher[j] - '0';
         } else {
            c = cipher[j] - 'A' + 10;
         }

         v += cipher_vic_map[c];               // add the decrypted nibble to the decrypted character value. now have the full val

         *plaintext = v;                       // copy the value to plaintext 
         plaintext++;                          // advance to the next position
      }
      *plaintext = 0x00;                       // null terminate the plain text
      r = 0;                                   // set result to success
   } else {
      r = -1;                                  // set result to failed
   }

   return r;                                   // return the result
}
