/* closedir.c
   This method closes an open directory handle.
   06/23/2023 initial version
   11/23/2023 updated to use separate dsr
   02/24/2024 broad changes for cache and dylib
              added spinner
   02/25/2024 modified to use dir_in_use from cache
*/

#include <dirent.h>
#include <dirent_private.h>
#include <spinner_private.h>
#include <cache_private.h>
#include <dylib.h>

int closedir (DIR *d) {
   int r;

   // confirm the directory info is in use
   if (cache.dir_in_use) {

      dylib.spinner_read ();

      dylib.spinner_write ();

      // close the DSR
      dir.df->dsr->pab.OpCode = DSR_CLOSE;
      r = dylib.dsrlnk (&dir.df->dsr->pab, dir.df->dsr->vdp_pab_buffer_addr);
 
      // mark all as no longer in use
      dir.df->dsr->in_use = false;
      dir.df->in_use      = false;
      cache.dir_in_use    = false;

      dylib.spinner_restore ();

   } else {
      r = -1;
   }

   return r;
}
