/* console_bitmap_clear_line.c
   This method clears a line.
   change log:
   01/13/2025 initial version
*/ 

#include <console.h>
#include <stdlib.h>

void console_bitmap_clear_line (int y0, int x0, int y1, int x1) {

   int y_diff = y1 - y0;         // 4
   int x_diff = x1 - x0;         // 4
   int y_mag = abs (y_diff);     // 4
   int x_mag = abs (x_diff);     // 4

   int y_add;
   int x_add;
 
   int dec;

   if (y_mag <= x_mag) {

      dec = x_mag / 2;           // 2

      if (y_diff < 0) {
         y_add = -1;             
      } else {
         y_add = 1;              // 1
      }

      if (x_diff < 0) {          
         x_add = -1;
      } else {
         x_add = 1;              // 1
      }

//    fprintf (stdout, "(%d, %d)\n", y0, x0);
      console_bitmap_clear_pixel (y0, x0);

      while (x0 != x1) {

         x0 += x_add;            // 1
         dec-= y_mag;            // 
         if (dec <= 0) {
            y0 += y_add;
//          dec = x_mag;
            dec += x_mag;
         }

//       fprintf (stdout, "(%d, %d)\n", y0, x0);
         console_bitmap_clear_pixel (y0, x0);
      }
   } else {

      dec = y_mag / 2;           // 2

      if (y_diff < 0) {
         y_add = -1;
      } else {
         y_add = 1;              // 1
      }

      if (x_diff < 0) {
         x_add = -1;
      } else {
         x_add = 1;              // 1
      }

//    fprintf (stdout, "(%d, %d)\n", y0, x0);
      console_bitmap_clear_pixel (y0, x0);

      while (y0 != y1) {

         y0 += y_add;            // 1
         dec-= x_mag;            //
         if (dec <= 0) {
            x0 += x_add;
//          dec = y_mag;
            dec += y_mag;
         }

//       fprintf (stdout, "(%d, %d)\n", y0, x0);
         console_bitmap_clear_pixel (y0, x0);
      }
   }
}
