/* console_bitmap_clear_line_right.c
   This method clears a horizontal line from left to right.
   change log:
   01/13/2025 initial version
*/

#include <console.h>
#include <vdp.h>
#include <math.h>

void console_bitmap_clear_line_right (int y, int x, int len) {
   const unsigned int row        = y >> 3;
   const unsigned int row_offset = y - (row << 3);
   unsigned int col              = x >> 3;
   unsigned int col_offset       = x - (col << 3);
   unsigned int addr             = (((row << 5) + col) << 3) + row_offset;
   unsigned char c;
   int len_this_section;

   len_this_section = min (8 - col_offset, len);
   len -= len_this_section;

   // handle the first byte
   VDP_SET_ADDRESS (addr);
   c = VDPRD;
   while (len_this_section) {
      c = c & (~ (0x01 << ( 7 - col_offset)));
      col_offset++;
      len_this_section--;
   }
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = c;
   addr += 8;

   // handle the next set of whole bytes
   len_this_section = (len >> 3);
   len -= len_this_section << 3;
   c = 0x00;
   while (len_this_section) {
      VDP_SET_ADDRESS_WRITE (addr);
      VDPWD = c;
      len_this_section--;
      addr += 8;
   }

   // handle the last byte if any remains
   len_this_section = len;
   col_offset = 0;
   VDP_SET_ADDRESS (addr);
   c = VDPRD;
   while (len_this_section) {
      c = c & (~ (0x01 << ( 7 - col_offset)));
      col_offset++;
      len_this_section--;
   }
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = c;
}
