/* console_bitmap_clear_pixel.c
   This method draws a single pixel.
   change log:
   01/13/2025 initial version
*/

#include <console.h>
#include <vdp.h>

void console_bitmap_clear_pixel (int y, int x) {
   const unsigned int row        = y >> 3;
   const unsigned int row_offset = y - (row << 3);
   const unsigned int col        = x >> 3;
   const unsigned int col_offset = x - (col << 3);
   const unsigned int addr = (((row << 5) + col) << 3) + row_offset;
   unsigned char c;

   VDP_SET_ADDRESS (addr);
   c = VDPRD;
   c = c & (~ (0x01 << ( 7 - col_offset)));
   VDP_SET_ADDRESS_WRITE (addr);
   VDPWD = c;
}
